% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlineCPD.R
\docType{methods}
\name{findCPprobs}
\alias{findCPprobs}
\title{Find Set of Changepoints with Highest probability}
\usage{
findCPprobs(currrunprobs, probmaxes, logprobcpstrunc, Rlength, t,
  minsep = 3, maxsep = 90, ppres = FALSE)
}
\arguments{
\item{currrunprobs}{The current most recently calculated
"R" vector, of run length probabilities (sums to 1).}

\item{probmaxes}{The probabilities of the set of changepoints
with the highest probability for each preceding time point.}

\item{logprobcpstrunc}{The set of changepoints with the highest
probability for each previous time point.}

\item{Rlength}{The length of the current R vector, to use in
case it was truncated.}

\item{t}{The current time point.}

\item{minsep}{The minimum distance of separation allowed for
eligible changepoint locations to be included in
the list of changepoints with the highest probability.}

\item{maxsep}{The maximum distance of separation allowed for
eligible changepoint locations to be included in
the list of changepoints with the highest probability.}

\item{ppres}{Set to true if wanting to return optional outputs,
useful for plotting and inspecting the algorithm, but not necessary.}
}
\value{
Two lists needed for the use in calculating this changepoints
for the next incoming time point: the vector of max probabilities for
each time point (probmaxes), and the list of changepoints with the
highest probability at each time point (changepoints: a list of lists).
It also returns ppresult: optional outputs, will be null if ppres=FALSE.
}
\description{
This function calculates the changepoints
with highest probability in the online algorithm
to take in the current probabilities at time t in the form
of a list of lists. It will not calculate the result at
every possible end point, because this will be done in the
main loop of online cpd as it iterates: the probmaxes and
cps list will be returned and passed into the function
again each time.
}
