% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echosounder.R
\name{read.echosounder}
\alias{read.echosounder}
\title{Read an echosounder File}
\usage{
read.echosounder(
  file,
  channel = 1,
  soundSpeed,
  tz = getOption("oceTz"),
  encoding = NA,
  debug = getOption("oceDebug"),
  processingLog
)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.}

\item{channel}{sequence number of channel to extract, for multi-channel
files.}

\item{soundSpeed}{sound speed, in m/s. If not provided, this is calculated
using \code{\link{swSoundSpeed}}\verb{(35,15,30,eos="unesco")}.  (In theory,
it could be calculated using the temperature and salinity that are stored
in the data file, but these will just be nominal values, anyway.}

\item{tz}{character string indicating time zone to be assumed in the data.}

\item{encoding}{ignored.}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}

\item{processingLog}{if provided, the action item to be stored in the log,
typically only provided for internal calls.}
}
\value{
An \linkS4class{echosounder} object.
}
\description{
Reads a biosonics echosounder file.  This function was written for and
tested with single-beam, dual-beam, and split-beam Biosonics files of type
V3, and may not work properly with other file formats.
}
\section{Bugs}{
 Only the amplitude information (in counts) is determined.  A
future version of this function may provide conversion to dB, etc.  The
handling of dual-beam and split-beam files is limited.  In the dual-beam
cse, only the wide beam signal is processed (I think ... it could be the
narrow beam, actually, given the confusing endian tricks being played).  In
the split-beam case, only amplitude is read, with the x-axis and y-axis
angle data being ignored.
}

\references{
Various echosounder instruments provided by BioSonics are
described at the company website, \verb{https://www.biosonicsinc.com/}.  The
document listed as reference 1 below was provided to the author of this function in
November 2011, which suggests that the data format was not changed since
July 2010.
\enumerate{
\item Biosonics, 2010.  DT4 Data File Format Specification.  BioSonics
Advanced Digital Hydroacoustics. July, 2010.  SOFTWARE AND ENGINEERING
LIBRARY REPORT BS&E-2004-07-0009-2.0.
}
}
\seealso{
The documentation for \linkS4class{echosounder} explains the
structure of \code{ctd} objects, and also outlines the other functions
dealing with them.

Other things related to echosounder data: 
\code{\link{[[,echosounder-method}},
\code{\link{[[<-,echosounder-method}},
\code{\link{as.echosounder}()},
\code{\link{echosounder}},
\code{\link{echosounder-class}},
\code{\link{findBottom}()},
\code{\link{plot,echosounder-method}},
\code{\link{subset,echosounder-method}},
\code{\link{summary,echosounder-method}}
}
\author{
Dan Kelley, with help from Clark Richards
}
\concept{things related to echosounder data}
