% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oceAxis}
\alias{oceAxis}
\title{Draw an Axis, Possibly with Decade-style Logarithmic Scaling}
\usage{
oceAxis(side, labels = TRUE, logStyle = "r", ...)
}
\arguments{
\item{side}{an integer specifying which axis to draw, with 1 for bottom axis, 2 for left axis,
3 for top axis, and 4 for right axis (as with \code{\link[=axis]{axis()}}).}

\item{labels}{either a vector of character values used for labels or a logical value indicating
whether to draw such labels.  The first form only works if the coordinate is not logarithmic,
and if \code{logStyle} is \code{"r"}.}

\item{logStyle}{a character value that indicates how to draw the y axis, if
\code{log="y"}.  If it is \code{"r"} (the default) then the conventional R style is used,
in which a logarithmic transform connects y values to position on the "page"
of the plot device, so that tics will be nonlinearly spaced, but not
organized by integral powers of 10.  However, if it is \code{"decade"}, then
the style will be that used in the scientific literature, in which large
tick marks are used for integral powers of 10, with smaller tick marks
at integral multiples of those powers, and with labels that use exponential
format for values above 100 or below 0.01.}

\item{\dots}{other graphical parameters, passed to \code{\link[=axis]{axis()}}.}
}
\value{
Numerical values at which tick marks were drawn (or would have been drawn, if \code{labels}
specified to draw them).
}
\description{
Draw an Axis, Possibly with Decade-style Logarithmic Scaling
}
\examples{
library(oce)
Ra <- 10^seq(4, 10, 0.1)
Nu <- 0.085 * Ra^(1 / 3)
plot(Ra, Nu, log = "xy", axes = FALSE)
box()
oceAxis(1, logStyle = "decade")
oceAxis(2, logStyle = "decade")

}
\author{
Dan Kelley
}
