% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithms.R
\name{XS_update}
\alias{XS_update}
\title{Processing a new data point for the 'XS' class}
\usage{
XS_update(x_new, X_recent, CUSUM, p0, w)
}
\arguments{
\item{x_new}{a new data point}

\item{X_recent}{matrix of \code{w} most recent observations}

\item{CUSUM}{tail partial sums of different lengths to be tracked online}

\item{p0}{sparsity parameter}

\item{w}{window parameter}
}
\value{
a list of
\itemize{
\item stat: test statistic for the 'XS' class.
\item X_recent: the updated X_recent matrix
\item CUSUM: the updated CUSUM matrix
}
}
\description{
This function implements the \code{\link{getData}} function to
perform the online changepoint detection for the 'XS' class.
}
\references{
Xie, Y. and Siegmund, D. (2013) Sequential multi-sensor change-point
detection.  \emph{Ann. Statist.}, \strong{41}, 670--692.
}
