% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggestions.R
\name{algo_similarity_based_reasoning}
\alias{algo_similarity_based_reasoning}
\title{Make suggestions using similarity based reasoning.}
\usage{
algo_similarity_based_reasoning(
  text_processed,
  sim_name = "wordwise",
  probabilities = occupationMeasurement::pretrained_models$similarity_based_reasoning,
  ...
)
}
\arguments{
\item{text_processed}{The processed user input.
Will be provided by get_job_suggestions.}

\item{sim_name}{Which similarity measure to use.
Possible values are "wordwise" or "substring".}

\item{probabilities}{Trained probabilities to be used,
defaults to the one bundled with the package. See \link{pretrained_models}.
This pretrained model always predicts a 5-digit code from the 2010 German
Classification of Occupations, with some exceptions: -0004 stands for
'Not precise enough/uncodable', -0006 stands for 'Multiple Jobs', -0012
stands for 'Blue-collar workers', -0019 stands for
'Volunteer/Social Service', and -0030 stands for 'Student assistant'.}

\item{...}{Additional arguments may be passed from \code{\link[=get_job_suggestions]{get_job_suggestions()}},
but will be ignored in this function.}
}
\value{
A data.table with suggestions or NULL if no suggestions were found.
}
\description{
The Algorithm used here corresponds to Algorithm #10 in (Schierholz, 2019).
Note: This function should not be used directly, but rather as a step /
algorithm in get_job_suggestions.
}
\examples{
\dontshow{data.table::setDTthreads(1)}

\dontrun{
# Use with default settings
if (interactive()) {
  get_job_suggestions(
    "Arzt",
    steps = list(
      simbased_default = list(
        algorithm = algo_similarity_based_reasoning
      )
    )
  )
}

# Use with substring similarity
if (interactive()) {
 get_job_suggestions(
   "Arzt",
   steps = list(
     simbased_substring = list(
       algorithm = algo_similarity_based_reasoning,
       parameters = list(
         sim_name = "substring"
       )
     )
   )
 )
}

# Comparison of algo_similarity_based_reasoning() with get_job_suggestions()

# Example of using algo_similarity_based_reasoning() directly. Not recommended.
if (interactive()) {
  algo_similarity_based_reasoning(
    preprocess_string("Arzt"),
    sim_name = "wordwise"
  )[order(score, decreasing = TRUE)]
}

# Same output as before, but the function is more adaptable.
if (interactive()) {
  get_job_suggestions(
    "Arzt",
    suggestion_type = "kldb-2010",
    num_suggestions = 1500,
    steps = list(
      simbased_default = list(
        algorithm = algo_similarity_based_reasoning,
        parameters = list(
          sim_name = "wordwise"
        )
      )
    )
  )[, list(kldb_id, score, sim_name, kldb_id_title = title)]
}
}
}
\references{
Schierholz, M. (2019). New Methods for Job and Occupation Classification (Ph.D. Thesis). University of Mannheim.
}
\seealso{
\code{\link[=get_job_suggestions]{get_job_suggestions()}}
}
