% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_civil_service_list.R
\name{nyc_civil_service_list}
\alias{nyc_civil_service_list}
\title{NYC Civil Service List (Active)}
\source{
NYC Open Data: <https://data.cityofnewyork.us/resource/vx8i-nprf>
}
\usage{
nyc_civil_service_list(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing Civil Service List (Active) data.
}
\description{
Downloads Civil Service List (Active) data from NYC Open Data.
}
\details{
This dataset provides information about active Civil Service lists,
including eligible candidates, examination numbers, and certification status.
Published by the NYC Department of Citywide Administrative Services (DCAS).
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_civil_service_list(limit = 10)
head(small_sample)

\donttest{
nyc_civil_service_list(limit = 5000)
nyc_civil_service_list(filters = list(last_name = "Martinez"))
}
}
