% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R, R/CNPJ.R, R/CPF.R, R/RENAVAN.R,
%   R/numbersBR.R
\name{is.valid}
\alias{is.valid}
\alias{is.valid.CNPJ}
\alias{is.valid.CPF}
\alias{is.valid.RENAVAN}
\alias{is.valid}
\title{Validate numbers}
\usage{
is.valid(x)

\method{is.valid}{CNPJ}(x)

\method{is.valid}{CPF}(x)

\method{is.valid}{RENAVAN}(x)
}
\arguments{
\item{x}{the identification number class.}
}
\value{
A logical vector indicating whether the number is valid or not.
}
\description{
Validates the brazilian numbers when it is necessary.
Not all identification numbers don't have a validation algorithm.
}
\examples{
is.valid(CNPJ(c(13515463000138, 66670000101))) # TRUE, FALSE
is.valid(CPF(c(1239157673, 42752486198))) # TRUE, FALSE
is.valid(RENAVAN(c(75320797785, 42752486198))) # TRUE, FALSE
}
