% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size.r
\name{sample_size}
\alias{sample_size}
\title{Sample size calculator}
\usage{
sample_size(n = 53:64, m = 20, pA = seq(1/20, 1/3, 0.01), conf = 0.95)
}
\arguments{
\item{n}{range of sample sizes to check, default is 53:64}

\item{m}{linup size, default 20}

\item{pA}{range of estimated detection rates to consider,
default is seq(1/20, 1/3, 0.01)}

\item{conf}{confidence level to use to simulate from binomial}
}
\description{
This function calculates a table of sample sizes for
with an experiment, given a lineup size, and
estimates of the detection rate.
}
\examples{
pow <- sample_size()
pow
library(ggplot2)
library(viridis)
ggplot(pow, aes(x=n, y=pA, fill=prob, group=pA)) +
  geom_tile() +
  scale_fill_viridis_c("power") +
  ylab("detect rate (pA)") + xlab("sample size (n)") +
  theme_bw()
}
