% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_arm.R
\name{per2haz}
\alias{per2haz}
\title{Convert exponential parameters}
\usage{
per2haz(x, per = 0.5)
}
\arguments{
\item{x}{survival percentile or exponential hazard rate}

\item{per}{(per)th percentile}
}
\value{
survival percentile or hazard rate.
}
\description{
Convert exponential survival percentile or hazard rate to the other.
}
\details{
\deqn{y=-log(1-per)/x}
}
\examples{
per2haz(14)          # hazard rate for exponential with 14-month median
per2haz(0.05)        # median survival for exponential with hazard rate 0.05
per2haz(14, 0.8)     # hazard rate for exponential with 80th percentile survival at 14 months
per2haz(0.27, 0.8)   # 80th percentile survival for exponential with hazard rate 0.27
}
