% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npsp-package.R
\docType{data}
\name{precipitation}
\alias{precipitation}
\title{Precipitation data}
\format{
A \code{\link[sp:SpatialGridDataFrame-class]{SpatialPointsDataFrame}} with 1053 observations on the 
following 6 variables:
\describe{
  \item{y}{total precipitations (square-root of rainfall inches),}
  \item{WBAN}{five-digit Weather station identifier,}
  \item{state}{factor containing the U.S. state,}
}
and the following \code{\link{attributes}}:
\describe{
  \item{labels}{list with data and variable labels,}
  \item{border}{\code{\link[sp]{SpatialPolygons}} with the boundary
  of the continental part of USA,}
  \item{interior}{\code{\link[sp]{SpatialPolygons}} with the U.S. state boundaries.}
}
}
\source{
National Climatic Data Center: \cr
\url{https://www.ncdc.noaa.gov/cdo-web/datasets}.
}
\description{
The data set consists of total precipitations during March 2016
recorded over 1053 locations on the continental part of USA.
}
\examples{
summary(precipitation)
scattersplot(precipitation)
}
\references{
Fernandez-Casal R., Castillo-Paez S. and Francisco-Fernandez M. (2017)
Nonparametric geostatistical risk mapping, \emph{Stoch. Environ. Res. Ris. Assess.}, 
\doi{10.1007/s00477-017-1407-y}.

Fernandez-Casal R., Castillo-Paez S. and Garcia-Soidan P. (2017)
Nonparametric estimation of the small-scale variability of heteroscedastic spatial processes, 
\emph{Spa. Sta.}, \doi{10.1016/j.spasta.2017.04.001}.
}
\keyword{datasets}
