% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.ts}
\alias{autoplot.ts}
\alias{autoplot.numeric}
\alias{fortify.ts}
\title{Automatically create a ggplot for time series objects.}
\usage{
\method{autoplot}{ts}(
  object,
  series = NULL,
  xlab = "Time",
  ylab = deparse(substitute(object)),
  main = NULL,
  facets = FALSE,
  colour = TRUE,
  ...
)

\method{autoplot}{numeric}(
  object,
  series = NULL,
  xlab = "Time",
  ylab = deparse(substitute(object)),
  main = NULL,
  ...
)

\method{fortify}{ts}(model, data, ...)
}
\arguments{
\item{object}{Object of class \dQuote{\code{ts}} or \dQuote{\code{mts}}.}

\item{series}{Identifies the time series with a colour, which integrates well
with the functionality of \link[forecast]{geom_forecast}.}

\item{xlab}{a string with the plot's x axis label. By default a NULL value.}

\item{ylab}{a string with the plot's y axis label. By default a counts" value.}

\item{main}{a string with the plot's title.}

\item{facets}{If TRUE, multiple time series will be faceted (and unless
specified, colour is set to FALSE). If FALSE, each series will be assigned a
colour.}

\item{colour}{If TRUE, the time series will be assigned a colour aesthetic.}

\item{...}{Other plotting parameters to affect the plot.}

\item{model}{Object of class \dQuote{\code{ts}} to be converted to
\dQuote{\code{data.frame}}.}

\item{data}{Not used (required for the `fortify` method).}
}
\value{
None. Function produces a ggplot2 graph.
}
\description{
\code{autoplot} takes an object of type \code{ts} or \code{mts} and creates
a ggplot object suitable for usage with \code{stat_forecast}.
}
\details{
\code{fortify.ts} takes a \code{ts} object and converts it into a data frame
(for usage with ggplot2).
}
\examples{

library(ggplot2)
autoplot(USAccDeaths)

lungDeaths <- cbind(mdeaths, fdeaths)
autoplot(lungDeaths)
autoplot(lungDeaths, facets=TRUE)

}
\seealso{
\code{\link[stats]{plot.ts}}, \code{\link[ggplot2]{fortify}}
}
\author{
Mitchell O'Hara-Wild
}
