% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_aug_functions.R
\name{summarize_chain}
\alias{summarize_chain}
\title{Posterior Inference based on a Sample from the Posterior}
\usage{
summarize_chain(chain, digits = 3)
}
\arguments{
\item{chain}{a numeric vector containing the samples from the posterior distribution.}

\item{digits}{the number of decimal places}
}
\value{
a list containing the posterior mean, median, and quantile-based credible intervals
calculated from the values in the chain.
}
\description{
\code{summarize_chain} provides posterior summaries based off a sample from the
posterior distribution.
}
\examples{
# Suppose the posterior distribution was Normal(15, 5)
posterior_chain <- rnorm(100, 15, 5); summarize_chain(posterior_chain)

}

