% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonLinearDotPlot.R
\name{dotscaling.log}
\alias{dotscaling.log}
\title{Predefined function to use as \code{dotscaling} in the \code{nonLinearDotPlot} function.}
\usage{
dotscaling.log(base = 2)
}
\arguments{
\item{base}{value of the base of the logarithm
Default value of base equals 2}
}
\value{
Function to calculate dot size with (log(c + base - 1) / log(base)) / c.
}
\description{
dotscaling(c) = (log(c + base - 1) / log(base)) / c is a logarithmic function
}
\references{
N. Rodrigues and D. Weiskopf, "Nonlinear Dot Plots",
IEEE Transactions on Visualization and Computer Graphics, vol. 24, no. 1, pp. 616-625, 2018.
Available: \doi{10.1109/TVCG.2017.2744018}
}
