% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TotalPoints.rms.R
\name{TotalPoints.rms}
\alias{TotalPoints.rms}
\title{Caculate Total Points for nomogram Picture}
\usage{
TotalPoints.rms(rd, fit, nom, kint = NULL)
}
\arguments{
\item{rd}{raw data}

\item{fit}{regression result in 'rma' package}

\item{nom}{nomoram() command result}

\item{kint}{number of intercept. Default is to use fit$interceptRef if it 
exists, or 1.}
}
\value{
a dataframe contains rawdata and total points
}
\description{
Compared with points_cal() command, TotalPoints.rms() is suit 
    for more complexed condition. Since this command is based on formula 
    from 'rms' package, it may be also more accurate. However, formula for 
    each variable can not be caculated.
}
\examples{
library(rms)
n <- 1000    
set.seed(17) 
d <- data.frame(age = rnorm(n, 50, 10),
                blood.pressure = rnorm(n, 120, 15),
                cholesterol = rnorm(n, 200, 25),
                sex = factor(sample(c('female','male'), n,TRUE)))

d <- upData(d,
            L = .4*(sex=='male') + .045*(age-50) +
              (log(cholesterol - 10)-5.2)*(-2*(sex=='female') + 2*(sex=='male')),
            y = ifelse(runif(n) < plogis(L), 1, 0))

ddist <- datadist(d); options(datadist='ddist')

f <- lrm(y ~ lsp(age,50) + sex * rcs(cholesterol, 4) + blood.pressure,
         data=d)
nom <- nomogram(f)
TotalPoints.rms(rd = d,fit = f,nom = nom)
}
