% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_aic.R
\name{shape_aic}
\alias{shape_aic}
\title{Fit Nominal Data to Theoretical Shapes Using AIC (Safe Exponential)}
\usage{
shape_aic(df, var, rate_exp = 0.7, eps = 1e-12)
}
\arguments{
\item{df}{A data.frame or tibble containing the nominal variable.}

\item{var}{Character string giving the name of the nominal variable in \code{df}.}

\item{rate_exp}{Numeric. Default exponential rate. Only used if tail not clearly exponential.}

\item{eps}{Small numeric value added to probabilities to avoid log(0). Default is 1e-12.}
}
\value{
A data.frame with columns: Shape, AIC, DeltaAIC.
}
\description{
Computes the multinomial log-likelihood of observed counts against
four theoretical distributions (uniform, triangular, normal-like,
and exponential/Pareto-like) and returns AIC and DeltaAIC values.
}
