% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_expression_similarity_counts.R
\name{calculate_expression_similarity_counts}
\alias{calculate_expression_similarity_counts}
\title{Calcualate the expression levels and expression levels similarity matrices using the count matrix}
\usage{
calculate_expression_similarity_counts(
  expression.matrix,
  similarity.measure = "correlation_pearson",
  n.elements.per.window = NULL,
  n.step = NULL,
  n.step.fraction = 0.05,
  ...
)
}
\arguments{
\item{expression.matrix}{the expression matrix, can be normalized or not}

\item{similarity.measure}{one of the correlation or distance metrics to be used,
defaults to pearson correlation; list of all methods in
\code{\link{get_methods_correlation_distance}}}

\item{n.elements.per.window}{number of elements to have in a window,
default 10\% of the number of rows}

\item{n.step}{step size to slide across, default 1\% of n.elements.per.window}

\item{n.step.fraction}{an alternative way to specify the step size, as a fraction of
the window length; default is 5\%}

\item{...}{arguments passed on to other methods}
}
\value{
A list with three elements: the first element is the expression matrix,
        as supplied; the other two are the expression levels matrix and
        expression levels similarity matrix;
        they have the same # of columns as the expression matrix,
        and n.elements.per.window * n.step rows.
}
\description{
This function generates an average similarity (correlation/inverse distance) coefficient
for every sliding window, for each sample in the expression matrix.
That is done by comparing the distribution of genes in each window across samples.
}
\examples{
calculate_expression_similarity_counts(
    expression.matrix = matrix(1:100, ncol = 5),
    similarity.measure = "correlation_pearson",
    n.elements.per.window = 3)
}
\seealso{
\code{\link{calculate_expression_similarity_transcript}}
}
