% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noah.R
\name{add_pseudonyms}
\alias{add_pseudonyms}
\title{Add column with pseudonyms to a data frame}
\usage{
add_pseudonyms(
  .data,
  ...,
  .name = "pseudonym",
  .before = NULL,
  .after = NULL,
  .ark = NULL
)
}
\arguments{
\item{.data}{A data frame to add pseudonyms to.}

\item{...}{Columns to use as keys on which pseudonyms should be based.
Supports tidy select. If empty, all columns will be used.}

\item{.name}{Name of the new column as string.}

\item{.before}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Destination of
columns selected by \code{...}. Supplying neither will move columns to the
left-hand side; specifying both is an error.}

\item{.after}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Destination of
columns selected by \code{...}. Supplying neither will move columns to the
left-hand side; specifying both is an error.}

\item{.ark}{An Ark object. If NULL (default) a new Ark is created. Using an
existing Ark makes sure that the same input returns the same pseudonym.}
}
\value{
A data frame with an additional column containing the pseudonyms.
}
\description{
Add column with pseudonyms to a data frame
}
\examples{
add_pseudonyms(mtcars)
}
