% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{cellsTij}
\alias{cellsTij}
\title{Entries for the Types I-IV cell-specific tests}
\usage{
cellsTij(ct, type = "III")
}
\arguments{
\item{ct}{A nearest neighbor contingency table}

\item{type}{The type of the cell-specific test, default=\code{"III"}. 
Takes on values \code{"I"}-\code{"IV"} (or 
equivalently \code{1-4}, respectively.}
}
\value{
A \code{matrix} of the values of Type I-IV cell-specific tests
}
\description{
Returns a \code{matrix} of same dimension as, \code{ct}, 
whose entries are the values
of the Types I-IV cell-specific test statistics, 
\eqn{T^I_{ij}-T^{IV}_{ij}}. 
The row and column names are inherited from \code{ct}. 
The type argument specifies the type
of the cell-specific test among the types I-IV tests. 
Equivalent to the function \code{\link{tct}} in this package.

See also (\insertCite{ceyhan:jkss-posthoc-2017;textual}{nnspat}) 
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

type.lab<-c("I","II","III","IV")
for (i in 1:4)
{ print(paste("T_ij values for cell specific tests for type",type.lab[i]))
  print(cellsTij(ct,i))
}

cellsTij(ct,"II")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)
cellsTij(ct,2)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
cellsTij(ct,2)

ct<-matrix(c(0,10,5,5),ncol=2)
cellsTij(ct,2)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{tct}} and \code{\link{nnct}}
}
\author{
Elvan Ceyhan
}
