% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{Xsq.nnsym}
\alias{Xsq.nnsym}
\title{Overall NN Symmetry Test with Chi-square Approximation}
\usage{
Xsq.nnsym(dat, lab, type = "dixon", ...)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{lab}{The \code{vector} of class labels (numerical or categorical)}

\item{type}{The type of the overall NN symmetry test with default=\code{"dixon"}.
Takes on values \code{"dixon"} and \code{"pielou"} for Dixon's and Pielou's (first type) overall NN symmetry test}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function}
}
\value{
A \code{list} with the elements
\item{statistic}{The chi-squared test statistic for Dixon's or Pielou's (first type of)
overall NN symmetry test}
\item{stat.names}{Name of the test statistic}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{k(k-1)/2} for this function.}
\item{estimate}{Estimates, i.e., absolute differences of the off-diagonal entries of 
NNCT (in the upper-triangular form).}
\item{est.name,est.name2}{Names of the estimates, former is a shorter description of the estimates
than the latter.}
\item{null.value}{Hypothesized null values for the differences between the expected values of the off-diagonal 
entries, which is 0 for this function.}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set, \code{dat}, or name of the contingency table, \code{ct}}
}
\description{
An object of class \code{"Chisqtest"} performing the hypothesis test of equality of the expected
values of the off-diagonal cell counts (i.e., entries) under RL or CSR in the NNCT for \eqn{k \ge 2} classes.
That is, the test performs Dixon's or Pielou's (first type of) overall NN symmetry test which is appropriate 
(i.e., have the appropriate asymptotic sampling distribution)
for completely mapped data or for sparsely sample data, respectively.
(See \insertCite{pielou:1961,dixon:1994,ceyhan:SWJ-spat-sym2014;textual}{nnspat} for more detail).

The \code{type="dixon"} refers to Dixon's overall NN symmetry test and 
\code{type="pielou"} refers to Pielou's first type of overall NN symmetry test.
The symmetry test is based on the chi-squared approximation of the corresponding quadratic form
and \code{type="dixon"} yields an extension of Dixon's NN symmetry test, which is extended by
\insertCite{ceyhan:SWJ-spat-sym2014;textual}{nnspat} and \code{type="pielou"} yields
Pielou's overall NN symmetry test.
 
The function yields the test statistic, \eqn{p}-value and \code{df} which is \eqn{k(k-1)/2}, description of the 
alternative with the corresponding null values (i.e., expected values) of differences of the off-diagonal entries,(which is
0 for this function) and also the sample estimates (i.e., observed values) of absolute differences of the off-diagonal entries of 
NNCT (in the upper-triangular form).
The functions also provide names of the test statistics, the description of the test and the data set used.

The null hypothesis is that all \eqn{E(N_{ij})=E(N_{ji})} for \eqn{i \ne j} in the \eqn{k \times k} NNCT (i.e., symmetry in the 
mixed NN structure) for \eqn{k \ge 2}.
In the output, if if \code{type="pielou"}, 
the test statistic, \eqn{p}-value and the df are valid only for (properly) sparsely sampled data.

See also
(\insertCite{pielou:1961,dixon:1994,ceyhan:SWJ-spat-sym2014;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

Xsq.nnsym(Y,cls)
Xsq.nnsym(Y,cls,method="max")
Xsq.nnsym(Y,cls,type="pielou")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))

Xsq.nnsym(Y,fcls)
Xsq.nnsym(Y,fcls,type="pielou")

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

Xsq.nnsym(Y,cls)
Xsq.nnsym(Y,cls,type="pielou")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Znnsym.ss}}, \code{\link{Znnsym.dx}} and \code{\link{Znnsym2cl}}
}
\author{
Elvan Ceyhan
}
