% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn_sum.R
\name{nn_sum}
\alias{nn_sum}
\alias{\%nn_sum\%}
\title{nn_sum}
\usage{
nn_sum(nu_1, nu_2)

nu_1 \%nn_sum\% nu_2
}
\arguments{
\item{nu_1}{A neural network.}

\item{nu_2}{A neural network.}
}
\value{
A neural network that is the neural network sum of \eqn{\nu_1} and \eqn{\nu_2}
i.e. \eqn{\nu_1 \oplus \nu_2}.

\emph{Note:} We have two versions, an infix version and a prefix version.
}
\description{
A function that performs the neural network sum for two
neural networks of the type generated by
create_nn().

For a specific definition, see:
}
\examples{
Prd(2.1, 0.1) |> nn_sum(Prd(2.1, 0.1))

}
\references{
Proposition 2.25. Grohs, P., Hornung, F., Jentzen, A. et al.
Space-time error estimates for deep neural network approximations
for differential equations. (2019).
\url{https://arxiv.org/abs/1908.03833}.
}
