% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sqr.R
\name{Sqr}
\alias{Sqr}
\title{Sqr}
\usage{
Sqr(q, eps)
}
\arguments{
\item{q}{a real number in \eqn{(2,\infty)}. Accuracy as well as computation
time increases as \eqn{q} gets closer to \eqn{2} increases}

\item{eps}{a real number in \eqn{(0,\infty)}. ccuracy as well as computation
time increases as \eqn{\varepsilon} gets closer to \eqn{0} increases}
}
\value{
A neural network that approximates the square of a real number.when
provided appropriate \eqn{q,\varepsilon} and upon instantiation with ReLU,
and a real number \eqn{x}
}
\description{
A function that returns the \eqn{\mathsf{Sqr}} neural networks.
}
\examples{
Sqr(2.5, 0.1)
Sqr(2.5, 0.1) |> inst(ReLU, 4)

}
\references{
Proposition 3.4. Grohs, P., Hornung, F., Jentzen, A. et al. Space-time error estimates for deep
neural network approximations for differential equations. (2019).
\url{https://arxiv.org/abs/1908.03833}

#' @references Definition 2.24. Rafi S., Padgett, J.L., Nakarmi, U. (2024)
Towards an Algebraic Framework For
Approximating Functions Using Neural Network Polynomials
\url{https://arxiv.org/abs/2402.01058}
}
