% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bins_CadeMenun2015}
\alias{bins_CadeMenun2015}
\title{NMR grouping bins from Cade-Menun (2015).}
\format{
A data frame with 5 rows and 5 variables:
\describe{
  \item{number}{Bin number}
  \item{group}{Name of bin group}
  \item{start}{ppm shift range, lower limit}
  \item{stop}{ppm shift range, upper limit}
  \item{description}{Description of the bin group}
}
}
\source{
B. Cade-Menun. "Improved peak identification in 31P-NMR spectra of environmental samples
with a standardized method and peak library". Geoderma.
\doi{10.1016/j.geoderma.2014.12.016}
}
\usage{
bins_CadeMenun2015
}
\description{
NMR grouping bins from  Cade-Menun (2015), for 31P, using D2O as a solvent.
(1) polyphosphate (-20 to -4);
(2) diester (-1.5 to 2.0);
(3) monoester (3.0 to 5.5);
(4) orthophosphate (5.5 to 9.0);
(5) phosphate (9.0 to 40.0)
}
\note{
The NMR spectrum can be split into several bins, based on
chemical shift (ppm). Binsets are specific to nuclei and solvents and
by definition are open on the left and closed on the right;
for example, a bin of (0,1) includes 1 but \emph{not} 0.
}
\seealso{
\code{\link{bins_Clemente2012}} \code{\link{bins_Lynch2019}}
\code{\link{bins_Mitchell2018}}
}
\keyword{datasets}
