% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bins_ss_Clemente2012}
\alias{bins_ss_Clemente2012}
\title{NMR grouping bins from Clemente et al. (2012) - ss.}
\format{
A data frame with 5 rows and 5 variables:
\describe{
  \item{number}{Bin number}
  \item{group}{Name of bin group}
  \item{start}{ppm shift range, lower limit}
  \item{stop}{ppm shift range, upper limit}
  \item{description}{Description of the bin group}
}
}
\source{
JS Clemente et al. 2012. “Comparison of Nuclear Magnetic Resonance
Methods for the Analysis of Organic Matter Composition from Soil Density and
Particle Fractions.” Environmental Chemistry
\doi{10.1071/EN11096}
}
\usage{
bins_ss_Clemente2012
}
\description{
NMR grouping bins from  Clemente et al. (2012), for solid-state NMR.
(1) alkyl C (0-50);
(2) O-alkyl C (60-93);
(3) anomeric C (95-110);
(4) aromatic C (110-160);
(5) carboxyl-carbonyl C (160-200)
}
\note{
The NMR spectrum can be split into several bins, based on
chemical shift (ppm). Binsets are specific to nuclei and solvents and
by definition are open on the left and closed on the right;
for example, a bin of (0,1) includes 1 but \emph{not} 0.
}
\seealso{
\code{\link{bins_Clemente2012}} \code{\link{bins_ss_Preston2009}}
\code{\link{bins_Mitchell2018}}
}
\keyword{datasets}
