% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindBestCut.R
\name{FindBestCut}
\alias{FindBestCut}
\title{Find the best cutoff values of binning for the visual predictive checks.}
\usage{
FindBestCut(X,
            K,
            beta = 0.2, ...)
}
\arguments{
\item{X}{A numeric vector to divide into K bins.}

\item{K}{Number of bins.}

\item{beta}{Additional parameter in the penalty. 
For more detailed explanation, see reference.}

\item{...}{Arguments to be passed to methods.}
}
\value{
The best cutoff values to make K bins using X and
        the minimum within sums of square values for the binning
}
\description{
By various rules, find the best cutoff values for a given 
number of bins.
}
\examples{
data(origdata)
FindBestCut(origdata$TIME,K=10)
}
\references{
Lavielle, M. and Bleakley, K.
            (2011). Automatic data binning for improved visual 
                    diagnosis of pharmacometric models. 
                    Journal of pharmacokinetics and pharmacodynamics, 38(6), 861-871.

VPC automatic binning algorithm in PsN 5.0.0 manual.
}
