% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zbeta_samples.R
\name{zbeta_samples}
\alias{zbeta_samples}
\title{Posterior samples of spatial effects and intercept for Matern with \eqn{nu=3/2}}
\usage{
zbeta_samples(
  coords = NULL,
  y = NULL,
  X = NULL,
  model = NULL,
  kernel = c("matern1", "matern2", "gaussian")
)
}
\arguments{
\item{coords}{coordinates}

\item{y}{response}

\item{X}{covariates (supply as a matrix without intercept)}

\item{model}{matrix of posterior samples of \eqn{\phi}, \eqn{\sigma^2} and \eqn{\tau^2}}

\item{kernel}{choice of kernel; must be one of "matern1", "matern2", "gaussian"}
}
\value{
A matrix containing posterior samples of spatial effects and the intercept.
}
\description{
For internal use only.
}
\examples{
\donttest{
require(nimble)
require(nimblewomble)

set.seed(1)
# Generated Simulated Data
N = 1e2
tau = 1
coords = matrix(runif(2 * N, -10, 10), ncol = 2); colnames(coords) = c("x", "y")
y = rnorm(N, mean = 20 * sin(sqrt(coords[, 1]^2  + coords[, 2]^2)), sd = tau)

# Posterior samples for theta
mc_sp = gp_fit(coords = coords, y = y, kernel = "matern2")
# Posterior samples for Z(s) and beta
model = zbeta_samples(y = y, coords = coords,
                      model = mc_sp$mcmc,
                      kernel = "matern2")
estimates = t(round(apply(model, 2, quantile,
              probs = c(0.5, 0.025, 0.975)), 3))
yfit = estimates[paste0("z[", 1:N, "]"), "50\%"] +
            estimates["beta[0]", "50\%"]
ylow = estimates[paste0("z[", 1:N, "]"), "2.5\%"] +
          estimates["beta[0]", "2.5\%"]
yhigh = estimates[paste0("z[", 1:N, "]"), "97.5\%"] +
            estimates["beta[0]", "97.5\%"]
fit_frame = data.frame(true = round(y, 3),
                        est = yfit, `2.5\%` = ylow, `97.5\%` = yhigh)
fit_frame$sig = significance(data_frame = data.frame(fit_frame[,-1]))

# Plot
sp_ggplot(data_frame = data.frame(coords, z = yfit, sig = fit_frame$sig))
}
}
\author{
Aritra Halder <aritra.halder@drexel.edu>, \cr Sudipto Banerjee <sudipto@ucla.edu>
}
\keyword{zbeta_samples}
