% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arcrest_tools.R
\name{query_usgs_arcrest}
\alias{query_usgs_arcrest}
\title{Query USGS Hydro ESRI Rest Server}
\usage{
query_usgs_arcrest(
  AOI = NULL,
  ids = NULL,
  type = NULL,
  service = NULL,
  where = NULL,
  t_srs = NULL,
  buffer = 0.5,
  page_size = 2000
)
}
\arguments{
\item{AOI}{sf (MULTI)POINT or (MULTI)POLYGON. An 'area of interest' can
be provided as either a location (sf POINT) or area (sf POLYGON)
in any Spatial Reference System.}

\item{ids}{character. A set of identifier(s) from the data
type requested, for 3dhp, this is id3dhp.}

\item{type}{character. Type of feature to return
If NULL (default) a data.frame of available types is returned}

\item{service}{character chosen from "3DHP_all", "NHDPlus_HR"}

\item{where}{character An where clause to pass to the server.}

\item{t_srs}{character (PROJ string or EPSG code) or numeric (EPSG code).
A user specified - target -Spatial Reference System (SRS/CRS) for returned objects.
Will default to the CRS of the input AOI if provided, and to 4326 for ID requests.}

\item{buffer}{numeric. The amount (in meters) to buffer a POINT AOI by for an
extended search. Default = 0.5}

\item{page_size}{numeric default number of features to request at a time. Reducing
may help if 500 errors are experienced.}
}
\value{
a simple features (sf) object or valid types if no type supplied
}
\description{
Query the USGS Hydro ESRI Rest Server for spatial data by location,
area, or ID.
}
\details{
The returned object(s) will have the same
Spatial Reference System (SRS) as the input AOI. If a individual or set of
IDs are used to query, then the default CRS of EPSG:4269 is
preserved. In all cases, a user-defined SRS can be passed to \code{t_srs}
which will override all previous SRS (either input or default).
All buffer and distance operations are handled internally using in
EPSG:5070 Albers Equal Area projection
}
\keyword{internal}
