% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,LogRatio,missing-method}
\alias{plot,GroupedLogRatio,missing-method}
\title{Plot Log-Ratios}
\usage{
\S4method{plot}{LogRatio,missing}(
  x,
  ...,
  jitter_factor = 1,
  jitter_amount = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes
)

\S4method{plot}{GroupedLogRatio,missing}(
  x,
  ...,
  jitter_factor = 1,
  jitter_amount = NULL,
  color = NULL,
  symbol = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  legend = list(x = "topright")
)
}
\arguments{
\item{x}{A \code{\linkS4class{LogRatio}} object.}

\item{...}{Further graphical parameters.}

\item{jitter_factor, jitter_amount}{A length-one \code{\link{numeric}} vector specifying
the amount of jitter (see \code{\link[=jitter]{jitter()}}).}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{color}{A (named) vector of colors (will be mapped to the group names
of \code{object}) or a \code{\link{function}} that when called with a single argument (an
integer specifying the number of colors) returns a vector of colors.}

\item{symbol}{A (named) vector of colors (will be mapped to the group names
of \code{object}).}

\item{legend}{A \code{\link{list}} of additional arguments to be passed to
\code{\link[graphics:legend]{graphics::legend()}}; names of the list are used as argument names.
If \code{NULL}, no legend is displayed.}
}
\value{
\code{plot()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{x}).
}
\description{
Displays a scatter plot.
}
\examples{
## Data from Day et al. 2011
data("kommos", package = "folio")
kommos <- remove_NA(kommos, margin = 1) # Remove cases with missing values
coda <- as_composition(kommos, parts = 3:22) # Coerce to compositional data

## Log ratio
clr <- transform_clr(coda)

## Boxplot
plot(clr)

## Use ceramic types for grouping
grp <- group(coda, by = kommos$type)
clr <- transform_clr(grp)
plot(clr)
}
\seealso{
Other plot methods: 
\code{\link{as_graph}()},
\code{\link{barplot}()},
\code{\link{boxplot}()},
\code{\link{hist}()},
\code{\link{pairs}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
