% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yth_filter.R
\name{yth_filter}
\alias{yth_filter}
\title{Filtered xts object}
\usage{
yth_filter(x, h = 8, p = 4, output = c("x", "trend", "cycle", "random"), ...)
}
\arguments{
\item{x}{A univariate \code{\link[xts]{xts}} object of any
\code{\link[zoo]{zoo}} index class, such as \code{\link[base]{Date}},
\code{\link[zoo]{yearmon}}, or \code{\link[zoo]{yearqtr}}.
For converting objects of type \code{timeSeries}, \code{ts}, \code{irts},
\code{fts}, \code{matrix}, \code{data.frame}, or \code{\link[zoo]{zoo}},
please see \code{\link[xts]{as.xts}}.}

\item{h}{An \code{integer}, defining the lookahead period.
Defaults to \code{h = 8}. The default assumes economic data of quarterly
periodicity with a lookahead period of 2 years.}

\item{p}{An \code{integer}, indicating the number of lags. Defaults to
\code{p = 4}, assuming quarterly data. For monthly data, one may choose
\code{p = 12} or aggregate to quarterly. Use this parameter to match
the seasonality of your data.}

\item{output}{A \code{character} vector. Defaults to
\code{output = c("x","trend","cycle","random")}, which returns the original
series (\code{"x"}), the fitted values from \code{\link{yth_glm}} (\code{"trend"}),
the residuals from \code{\link{yth_glm}} (\code{"cycle"}), and a random walk
defined by differencing \eqn{y_{t+h}} and \eqn{y_t} (\code{"random"}).
Any subset of these components can be returned.}

\item{...}{Other arguments passed to \code{\link[stats]{glm}}.}
}
\value{
An \code{\link[xts]{xts}} object defined by the \code{output} parameter.
}
\description{
\code{yth_filter} returns an \code{\link[xts]{xts}} object containing
user-defined combinations of the original, trend, cycle, and random walk series.
}
\details{
For time series of quarterly periodicity, Hamilton suggests parameters of
h = 8 and p = 4, or an \eqn{AR(4)} process, additionally lagged by \eqn{8}
lookahead periods. Econometricians may explore variations of h. However, p
is designed to correspond with the seasonality of a given periodicity and
should be matched accordingly.
}
\examples{
data(GDPC1)

gdp_filter <- yth_filter(100*log(GDPC1), h = 8, p = 4)

head(gdp_filter, 15)

#---------------------------------------------------------------------------#

data(PAYEMS)

log_Employment <- 100*log(xts::to.quarterly(PAYEMS["1947/2016-6"], OHLC = FALSE))

employ_trend <- yth_filter(log_Employment, h = 8, p = 4, output = c("x", "trend"))

plot(employ_trend, grid.col = "white", legend.loc = "topleft",
         main = "Log of Employment and trend")

#----------------------------------------------------------------------------#

quarterly_data <- 100*log(merge(GDPC1, PCECC96, GPDIC1, EXPGSC1, IMPGSC1, GCEC1, GDPDEF))

cycle <- do.call(merge, lapply(quarterly_data, yth_filter, output = "cycle"))
random <- do.call(merge, lapply(quarterly_data, yth_filter, output = "random"))

cycle.sd <- t(data.frame(lapply(cycle, sd, na.rm = TRUE)))
GDP.cor <- t(data.frame(lapply(cycle, cor, cycle[,1], use = "complete.obs")))
random.sd <- t(data.frame(lapply(random, sd, na.rm = TRUE)))
random.cor <- t(data.frame(lapply(random, cor, random[,1], use = "complete.obs")))

my_table_2 <- round(data.frame(cbind(cycle.sd, GDP.cor, random.sd, random.cor)), 2)
names(my_table_2) <- names(Hamilton_table_2)[1:4]

my_table_2
}
\references{
James D. Hamilton.
\href{http://econweb.ucsd.edu/~jhamilto/hp.pdf}{Why You Should Never Use the Hodrick-Prescott Filter}.
NBER Working Paper No. 23429, Issued in May 2017.
}
\seealso{
\code{\link{yth_glm}}
}
