% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuromaps.R
\name{neuromaps_available}
\alias{neuromaps_available}
\title{List available neuromaps annotations}
\usage{
neuromaps_available(
  source = NULL,
  desc = NULL,
  space = NULL,
  density = NULL,
  resolution = NULL,
  hemisphere = NULL,
  tags = NULL,
  format = NULL,
  refresh = FALSE,
  fixed = FALSE
)
}
\arguments{
\item{source}{Data source identifier (e.g. \code{"abagen"}, \code{"beliveau"}).}

\item{desc}{Map descriptor key (e.g. \code{"genepc1"}, \code{"feobv"}).}

\item{space}{Coordinate space (e.g. \code{"fsaverage"}, \code{"MNI152"}, \code{"fsLR"}).}

\item{density}{Surface vertex density (e.g. \code{"10k"}, \code{"164k"}). Mutually
exclusive with \code{resolution}.}

\item{resolution}{Volume voxel resolution (e.g. \code{"1mm"}, \code{"2mm"}). Mutually
exclusive with \code{density}.}

\item{hemisphere}{Hemisphere (\code{"L"} or \code{"R"}).}

\item{tags}{Character vector of tags. All must match (AND logic).}

\item{format}{Filter by format (\code{"surface"} or \code{"volume"}).}

\item{refresh}{Logical. If \code{TRUE}, forces a fresh download of the
registry data, ignoring any session cache.}

\item{fixed}{Logical. If \code{TRUE}, filter strings are matched literally
rather than as regular expressions.}
}
\value{
A tibble of available annotations with columns: source, desc,
space, den, res, hemi, format, fname, full_desc, tags, N, age.
}
\description{
Query the neuromaps registry to see which brain map annotations are
available for download. Data is fetched from the
\href{https://github.com/netneurolab/neuromaps}{neuromaps} project's GitHub
repository and cached for the session.
}
\details{
All string filter parameters (\code{source}, \code{desc}, \code{space}, \code{density},
\code{resolution}, \code{hemisphere}, \code{format}) are treated as \strong{R regular
expressions} and matched with \code{\link[=grepl]{grepl()}}. For example,
\code{source = "^beliveau$"} matches exactly, while \code{source = "bel"} matches
any source containing \code{"bel"}. Set \code{fixed = TRUE} for literal string
matching. The \code{tags} parameter always uses exact matching (AND logic).

When used in \code{\link[=fetch_neuromaps_annotation]{fetch_neuromaps_annotation()}}, \code{source}, \code{desc}, and \code{space}
are exact matches.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
neuromaps_available()
neuromaps_available(source = "beliveau")
neuromaps_available(tags = "pet")
\dontshow{\}) # examplesIf}
}
