% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BrainRegion3D.R
\name{RegionSquare}
\alias{RegionSquare}
\title{Create a square region of interest where the z-dimension is fixed at one voxel coordinate.}
\usage{
RegionSquare(bvol, centroid, surround, fill = NULL, nonzero = FALSE,
  fixdim = 3)
}
\arguments{
\item{bvol}{an \code{BrainVolume} or \code{BrainSpace} instance.}

\item{centroid}{the center of the cube in \emph{voxel} coordinates.}

\item{surround}{the number of voxels on either side of the central voxel.}

\item{fill}{optional value(s) to assign to data slot.}

\item{nonzero}{keep only nonzero elements from \code{bvol}. If \code{bvol} is A \code{BrainSpace} then this argument is ignored.}

\item{fixdim}{the fixed dimension is the third, or z, dimension.}
}
\value{
an instance of class \code{ROIVolume}.
}
\description{
Create a square region of interest where the z-dimension is fixed at one voxel coordinate.
}
\examples{
 sp1 <- BrainSpace(c(10,10,10), c(1,1,1))
 square <- RegionSquare(sp1, c(5,5,5), 1)
 vox <- coords(square)
 ## a 3 X 3 X 1 grid
 nrow(vox) == 9
}

