% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapped_neurovec.R, R/neurovec.R, R/neurovol.R,
%   R/sparse_neurovec.R
\name{load_data,MappedNeuroVecSource-method}
\alias{load_data,MappedNeuroVecSource-method}
\alias{load_data,NeuroVecSource-method}
\alias{load_data,NeuroVolSource-method}
\alias{load_data,SparseNeuroVecSource-method}
\title{Load image data from a NeuroVecSource object}
\usage{
\S4method{load_data}{MappedNeuroVecSource}(x)

\S4method{load_data}{NeuroVecSource}(x)

\S4method{load_data}{NeuroVolSource}(x)

\S4method{load_data}{SparseNeuroVecSource}(x)
}
\arguments{
\item{x}{The NeuroVecSource object containing the image metadata and file information.}
}
\value{
a DenseNeuroVec object
}
\description{
This function loads the image data from a NeuroVecSource object, handling various
dimensionalities and applying any necessary transformations.
}
\details{
This method performs the following steps:
1. Validates the dimensionality of the metadata.
2. Reads the image data using RNifti.
3. Handles 5D arrays by dropping the 4th dimension if it has length 1.
4. Applies slope scaling if present in the metadata.
5. Constructs a NeuroSpace object with appropriate dimensions and spatial information.
6. Creates and returns a DenseNeuroVec object, handling both 3D and 4D input arrays.
}
\note{
This method currently only supports NIfTI file format through RNifti.
}
\seealso{
\code{\link{NeuroVecSource}}, \code{\link{DenseNeuroVec}}, \code{\link{NeuroSpace}}
}
