% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netShiny.R
\name{netShiny}
\alias{netShiny}
\title{This function launches the netShiny Shiny app.}
\usage{
netShiny(Net.obj = NULL, mapping = NULL, resamples = NULL)
}
\arguments{
\item{Net.obj}{A list of (sparse) matrices corresponding to the networks that need to be visualized. Net.obj can also be a list of dataframes with data to be used to reconstruct networks.  Or, Net.obj can be a combination of (sparse) matrices and dataframes. If items in list are names, these names will be used, otherwise automatic names will be generated.}

\item{mapping}{A dataframe containing order for each node. There should be a column with the names of the nodes and a column with the corresponding group that the nodes belong to. The app will automatically choose the column representing the grouping of the nodes by looking at the first two columns, and choosing the column with the less number of factor levels as the columns containing the grouping of the nodes.}

\item{resamples}{If an user has resampling information corresponding to the networks to be visualized the user can also include this in the function, which will incorporate it into the app.}
}
\value{
A Shiny app.
}
\description{
This function launches the netShiny Shiny app.
}
\details{
This function opens the shiny app, netShiny. All of the arguments in netShiny are optional, so netShiny can be called without any arguments. Users are prompted with a series of modal dialogs after running the netShiny function. The first modal dialog gives users the possibility to upload files to the app and show the dataframes that already uploaded in a datatable. Users can choose files which contain information to reconstruct networks from them. The next modal dialog let users reconstruct networks using the dataframes that were uploaded. netShiny uses the functions netphenogeno and selectnet from the package netgwas for graph structure learning from non-Gaussian data. The next modal let users optionally choose a file containing the ordering of the nodes. If a dataframe containing the ordering of the nodes was already passed to mapping argument, this modal will visualize this in a datatable. The last modal let users choose the mode they want the app to run in, GxE (Genetic-by-Environment) or general mode. In GxE mode the language used in netShiny is more Genetic-by-Environment related. Users need to input the number of traits if GxE mode is chosen, and optionally, manually input a grouping for the traits.
}
\examples{
if (interactive()) {
    netShiny()
}
}
\references{
Behrouzi, P., and Wit, E. C. (2017c). netgwas: An R Package for Network-Based Genome-Wide Association Studies. arXiv preprint, arXiv:1710.01236.
}
\seealso{
\code{\link[netgwas]{netphenogeno}}, \code{\link[netgwas]{selectnet}}
}
\author{
Rocherno de Jongh and Pariya Behrouzi \cr
Maintainer: Rocherno de Jongh \email{rocherno.dejongh@hotmail.com}
}
