% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peptide_stats.R
\name{peptide_stats}
\alias{peptide_stats}
\title{Calculate percentage of shared vs specific peptides}
\usage{
peptide_stats(incM)
}
\arguments{
\item{incM}{a \code{logical} \code{matrix} containing the incidence matrix
with its column and row names (respectively, protein and peptide identifiers)
and 0 or 1 values indicating whether or not the peptide maps on the
corresponding protein.}
}
\value{
a \code{list} of three elements: i. number of shared peptides;
ii. number of specific peptides; iii. percentage of specific peptides
}
\description{
Read in input the incidence matrix of peptide-to-protein mappings generated
from valid proteomic identifications
}
\examples{
# Read the tab-delimited file containing he proteome incidence matrix
incM_filename <- system.file( "extdata"
                             , "incM_example"
                             , package = "net4pg"
                             , mustWork = TRUE)
rownames_filename <- system.file( "extdata"
                                  , "peptideIDs_incM_example"
                                  , package = "net4pg"
                                  , mustWork = TRUE)
colnames_filename <- system.file( "extdata"
                                 , "proteinIDs_incM_example"
                                 , package = "net4pg"
                                 , mustWork = TRUE)
incM <- read_inc_matrix(incM_filename = incM_filename
                 , colnames_filename = colnames_filename
                 , rownames_filename = rownames_filename)
# Calculate percentage of shared vs specific peptides
peptideStatsOut <- peptide_stats(incM = incM)

}
\author{
Laura Fancello
}
