% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_data.R
\name{neon_data}
\alias{neon_data}
\title{Query the NEON API for URLs of matching data products
Repeated requests will be cached}
\usage{
neon_data(
  product,
  start_date = NA,
  end_date = NA,
  site = NA,
  type = NA,
  release = NA,
  quiet = FALSE,
  api = "https://data.neonscience.org/api/v0",
  .token = Sys.getenv("NEON_TOKEN")
)
}
\arguments{
\item{product}{A NEON \code{productCode} or list of product codes, see examples.}

\item{start_date}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}

\item{end_date}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}

\item{site}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}

\item{type}{Should we prefer the basic or expanded version of this product?
Note that not all products have expanded formats.}

\item{release}{Select only data files associated with a particular release tag,
see \url{https://www.neonscience.org/data-samples/data-management/data-revisions-releases},
e.g. "RELEASE-2021".  Releases are associated with a specific DOI and the promise that
files associated with a particular release will not change.}

\item{quiet}{Should download progress be displayed?}

\item{api}{the URL to the NEON API, leave as default.}

\item{.token}{an authentication token from NEON. A token is not
required but will allow access to a higher number of requests before
rate limiting applies, see
\url{https://data.neonscience.org/data-api/rate-limiting/#api-tokens}.
Note that once files are downloaded once, \code{neonstore} provides persistent
access to them without further interaction required with the API.}
}
\value{
a data.frame containing the name, filesize (in bytes),
checksums (columns md5, crc32, or crc32c, though each product will use
only one of these), url, and release status.
}
\description{
Query the NEON API for URLs of matching data products
Repeated requests will be cached
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

x <- neon_data("DP1.10003.001") 
x <- neon_data("DP1.10003.001", release="RELEASE-2021") 
\dontshow{\}) # examplesIf}
}
