% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consensusChangeECDF.R
\name{consensusChangeECDF}
\alias{consensusChangeECDF}
\title{Change in Area Under the ECDF}
\usage{
consensusChangeECDF(neatmap_res)
}
\arguments{
\item{neatmap_res}{Output from the \code{\link{neatmap}} function.}
}
\value{
A ggplot of the change in consecutive area under the ECDFs of the 
consensus cluster matrices.
}
\description{
\code{consensusChangeECDF} plots the relative change in area under empirical 
cumulative distribution function for consecutive consensus cluster matrices
produced using the \code{\link{neatmap}} function.
}
\examples{
#' # create the data frame using the network, node and edge attributes
df <- netsDataFrame(network_attr_df,
                    node_attr_df,
                    edge_df)

# run the neatmap code on df
neat_res <- neatmap(df, scale_df = "ecdf", max_k = 3, reps = 100, 
                    xlab = "vars", ylab = "nets", xlab_cex = 1, ylab_cex = 1)
                    
# visualize the relative change in AU ECDF of consecutive consensus cluster 
# iterations
consensusChangeECDF(neat_res)
}
\references{
For more information on the consensus matrices, see
\href{https://link.springer.com/article/10.1023\%2FA\%3A1023949509487}{Monti et al.}.
}
\author{
Philippe Boileau, \email{philippe_boileau@berkeley.edu}
}
