% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/player_match_stats.R
\name{player_match_stats}
\alias{player_match_stats}
\title{Extract player statistics for a particular match}
\usage{
player_match_stats(
  contest = NULL,
  team = NULL,
  team_stats = TRUE,
  sport = "WVB"
)
}
\arguments{
\item{contest}{Contest ID determined by NCAA for match. To find ID, use
\code{\link[=find_team_contests]{find_team_contests()}} for a team and season.}

\item{team}{Name of school. Must match name used by NCAA. Find exact team
name with \code{\link[=find_team_name]{find_team_name()}}.}

\item{team_stats}{Logical indicating whether to include (TRUE) or exclude
(FALSE) team statistics. Default includes team statistics with player
statistics.}

\item{sport}{Three letter abbreviation for NCAA sport (must be upper case;
for example "WVB" for women's volleyball and "MVB" for men's volleyball).}
}
\value{
By default, returns data frame that includes both home and away team match
statistics. If team is specified, only that team's data are returned.
}
\description{
The NCAA's page for a match/contest includes a tab called
"Individual Statistics". This function extracts the tables of player
match statistics for both home and away teams, as well as team statistics
(though these can be omitted). If a particular team is specified, only that
team's statistics will be returned.
}
\note{
This function \strong{requires internet connectivity} as it checks the
\href{https://stats.ncaa.org}{NCAA website} for information.
It also uses the \href{https://rstudio.github.io/chromote/}{\code{{chromote}}} package
and \strong{requires \href{https://www.google.com/chrome/}{Google Chrome}} to be
installed.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
player_match_stats(contest = "6080706")
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions that extract player statistics: 
\code{\link{player_season_stats}()}
}
\concept{functions that extract player statistics}
