% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy.R
\name{energy}
\alias{energy}
\title{Mechanical energy of an N-body system}
\usage{
energy(m, x, v, rsmooth = 0, G = 6.67408e-11, cpp = TRUE)
}
\arguments{
\item{m}{N-vector with the masses of the N particles. Negative masses are treated as positive masses of same magnitude, since negative masses normally represent positive background masses in the nbody package.}

\item{x}{N-by-3 matrix specifying the initial position in Cartesian coordinates}

\item{v}{N-by-3 matrix specifying the initial velocities}

\item{rsmooth}{top-hat smoothing radius.}

\item{G}{gravitational constant. The default is the measured value in SI units.}

\item{cpp}{logical flag. If TRUE (default), the computation is performed efficiently in C++.}
}
\value{
Returns a list with vector items \code{Ekin}, \code{Epot}, \code{Emec=Ekin+Epot}; and the associated total quantities \code{Ekin.tot}, \code{Epot.tot}, \code{Emec=Ekin+Epot.tot}.
}
\description{
Computes the instantaneous potential and kinetic energies of all particles in an N-body system. Here, the potential energy of a particle i means the potential energy it has with all other particles (sum_j -G*m[i]*[j]/rij). Hence the total potential energy of the system is half the sum of the individual potential energies.
}
\author{
Danail Obreschkow
}
