% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_name_crossref.R
\name{drop_name_crossref}
\alias{drop_name_crossref}
\title{Create visual citation from Crossref data}
\usage{
drop_name_crossref(dois, ...)
}
\arguments{
\item{dois}{One or several dois to create visual citations for. If they are named, these names are used as filenames; otherwise they are generated based on authors and years.}

\item{...}{
  Arguments passed on to \code{\link[=drop_name]{drop_name}}
  \describe{
    \item{\code{export_as}}{A string specifying the desired output format. For now supports PNG and HTML.
Use "html" to include the 'bare' taglist (recommended for inclusion in Rmarkdown documents) or "html_full" to write a standalone .html file including <head> etc.
The PNG is a screenshot of the rendered HTML via the 'webshot' package. The filename represents this two step approach on purpose.
For webshot you need to install phantomJS once (see 'webshot' documentation).}
    \item{\code{output_dir}}{A string specifying the relative path, where the rendered output files should be stored.}
    \item{\code{max_authors}}{Integer number of maximum authors to print. If the number of authors exceeds this, the list is cropped accordingly.}
    \item{\code{include_qr}}{Character string specifying the way the QR code should be included or if no QR code should be included.
'embed' results in a stand alone <img> tag within the HTML object, other options are ignored for the time being.
'link' (default) creates a PNG of the QR code and stores it in a subfolder of the HTML file's location. The HTML <img> tag links to this file then.
'link_svg' creates a SVG of the QR code and stores it in a subfolder of the HTML file's location. The HTML <img> tag links to this file then.
'none' creates no QR code.}
    \item{\code{style}}{A string specifying the desired style for the visual citation. Possible values are:
"modern", "classic", "clean", "fancy", "newspaper", "compact" and "none".
If "compact" is given, the rendered VC contains
only the last name of the first author and the publication year, next to the QR code.
If "none" is given, the returned html can use a custom css file provided by the user.
This custom CSS file must specify styles for <div> classes "top-row", "title-row" and "author-row". (see vignette)}
    \item{\code{path_absolute}}{Boolean to specify, whether the returned output path is a relative path or an absolute path.}
    \item{\code{use_xaringan}}{Boolean to specify if an HTML output is intended to be included in an HTML presentation (like e.g. xaringan) or not.
When including the visual citation via htmltools::includeHTML(), the QR code needs to be in a subfolder
relative to the rendered presentation, not relative to the visual citation.}
    \item{\code{clean_strings}}{Removes curly braces {} from titles and journal names, as they are often present in
BibTeX strings, but not needed for the rendering. TRUE by default, but can be set to FALSE, if the {} are needed.}
    \item{\code{qr_size}}{Specifies the height/width of the rendered QR code in px. Default: 250px, minimum: 150px. Ignored for SVG output.}
    \item{\code{qr_color}}{Specifies the foreground color of the QR code as hex-string, e.g. "#00FF00"; default is black: "#000000".}
    \item{\code{qr_hyperlink}}{Logical. Should the QR code be a hyperlink?}
    \item{\code{vc_width}}{Specifies the width of the text part of the visual citation in px.
This can be adjusted to accommodate e.g. untypically long or short titles. Default: 600px}
  }}
}
\value{
A character string with the file path to the created visual citation in the specified output format.
}
\description{
Takes one or several dois and extracts information from Crossref, then processes them into visual citations with \code{\link{drop_name}}. Requires {rcrossref} > v1.1, see README for further details.
}
\examples{
\dontrun{
drop_name_crossref(c(cite1 = "10.1126/science.169.3946.635", cite2 = "10.1111/joms.12670"))
}

}
