% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/super_learner.R
\name{predict.nadir_sl_model}
\alias{predict.nadir_sl_model}
\title{Predict from a \code{nadir::super_learner()} model}
\usage{
\method{predict}{nadir_sl_model}(object, newdata, ...)
}
\arguments{
\item{object}{An object of class inheriting from \code{nadir_sl_model}.}

\item{newdata}{A tabular data structure (data.frame or matrix) of
predictor variables.}

\item{...}{Ellipses, solely provided so that the \code{predict.nadir_sl_model} method
is compatible with the generic \code{predict}, which takes ellipses as an argument.}
}
\value{
a numeric vector of predicted values
}
\description{
Predict from a \code{nadir::super_learner()} model
}
\examples{
sl_fit <- super_learner(mtcars, mpg ~ hp,
  learners = list(lnr_lm, lnr_rf, lnr_earth))
predict(sl_fit, newdata = mtcars)
}
