% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_test_result.R
\name{TestResult}
\alias{TestResult}
\title{Test Result S7 Class}
\usage{
TestResult(
  method_name = stop("@method_name is required"),
  test_stat = stop("@test_stat is required"),
  fitting_dist = stop("@fitting_dist is required"),
  params = stop("@params is required"),
  alternative = "two-sided",
  null_sample = stop("@null_sample is required"),
  data_name = character(0),
  p_label = "p_val"
)
}
\arguments{
\item{method_name}{Character string identifying the test method}

\item{test_stat}{Numeric test statistic value}

\item{fitting_dist}{Distribution object used for null hypothesis testing}

\item{params}{List of fitted distribution parameters}

\item{alternative}{Character string specifying alternative hypothesis ("two-sided", "less", "greater")}

\item{null_sample}{Numeric vector of null distribution samples}

\item{data_name}{Character string naming the dataset (optional)}

\item{p_label}{Character string for p-value label (default: "p_val")}
}
\value{
A TestResult object
}
\description{
S7 class for storing and manipulating statistical test results
from phylotranscriptomic conservation tests.
}
\details{
The TestResult class provides computed properties including:
- `p_value`: Computed p-value based on test statistic and fitted distribution
}
