% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/states.R
\name{mc_states_outlier}
\alias{mc_states_outlier}
\title{Create states for outlying values}
\usage{
mc_states_outlier(
  data,
  table,
  period = NULL,
  range_tag = "range",
  jump_tag = "jump"
)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}

\item{table}{The table with outlying values (thresholds). You can use the output of \code{\link[=mc_info_range]{mc_info_range()}}. The columns of the table are:
\itemize{
\item \code{sensor_name} - Name of the sensor (e.g., TMS_T1, TMS_moist, HOBO_T); see \link{mc_data_sensors}
\item \code{min_value} - Minimal value (threshold; all below are tagged)
\item \code{max_value} - Maximal value
\item \code{positive_jump} - Maximal acceptable increase between two consecutive values (next value is higher than the previous)
\item \code{negative_jump} - Maximal acceptable decrease between two consecutive values (next value is lower than the previous)
}}

\item{period}{Period for standardizing the value of jump. If NULL, then the difference is not standardized (default NULL); see details.

It is a character string usable by \link[lubridate:period]{lubridate::period}, for example, "1 hour", "30 minutes", "2 days".}

\item{range_tag}{The tag for states indicating that the value is out of range (default "range").}

\item{jump_tag}{The tag for states indicating that the difference between two consecutive values is too high (default "jump").}
}
\value{
Returns a myClim object in the same format as the input, with added states.
}
\description{
This function creates a state (tag) for all values that are either above
or below certain thresholds (\code{min_value}, \code{max_value}), or at break
points where consecutive values of microclimate time-series suddenly
jump down or up (\code{positive_jump}, \code{negative_jump}).
}
\details{
The best way to use this function is to first generate a
table (data.frame) with pre-defined minimum, maximum, and jump thresholds
using the \link{mc_info_range} function. Then modify the thresholds as needed
and apply the function (see example). All values above \code{max_value} and below
\code{min_value} are tagged by default with the \code{range} tag. When consecutive
values suddenly decrease by more than \code{negative_jump} or increase
by more than \code{positive_jump}, such break points are tagged with the \code{jump} tag.
It is possible to use only the \code{range} case, only the \code{jump} case, or both.

When the \code{period} parameter is used, the jump values are modified;
range values are not affected. Depending on the logger step, the
value of jump is multiplied or divided. For example, when the loggers
are recording with a step of 15 minutes (900 s) and the user sets
\code{period = "1 hour"} together with \code{positive_jump = 10}, then consecutive
values differing by (10 * (15 / 60) = 2.5) would be tagged. In this example,
but with recording step 2 hours (7200 s), consecutive values differing
by (10 * (120 / 60) = 20) would be tagged.
}
\examples{
range_table <- mc_info_range(mc_data_example_clean)
range_table$negative_jump[range_table$sensor_name == "TMS_moist"] <- 500
data <- mc_states_outlier(mc_data_example_clean, range_table)
}
