% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc.mvgam.R
\name{pp_check.mvgam}
\alias{pp_check.mvgam}
\alias{pp_check}
\title{Posterior Predictive Checks for \code{mvgam} models}
\usage{
\method{pp_check}{mvgam}(
  object,
  type,
  ndraws = NULL,
  prefix = c("ppc", "ppd"),
  group = NULL,
  x = NULL,
  newdata = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{mvgam}}

\item{type}{Type of the ppc plot as given by a character string.
See \code{\link[bayesplot:PPC-overview]{PPC}} for an overview
of currently supported types. You may also use an invalid
type (e.g. \code{type = "xyz"}) to get a list of supported
types in the resulting error message.}

\item{ndraws}{Positive integer indicating how many
posterior draws should be used.
If \code{NULL} all draws are used. If not specified,
the number of posterior draws is chosen automatically.
Ignored if \code{draw_ids} is not \code{NULL}.}

\item{prefix}{The prefix of the \pkg{bayesplot} function to be applied.
Either `"ppc"` (posterior predictive check; the default)
or `"ppd"` (posterior predictive distribution), the latter being the same
as the former except that the observed data is not shown for `"ppd"`.}

\item{group}{Optional name of a factor variable in the model
by which to stratify the ppc plot. This argument is required for
ppc \code{*_grouped} types and ignored otherwise.}

\item{x}{Optional name of a variable in the model.
Only used for ppc types having an \code{x} argument
and ignored otherwise.}

\item{newdata}{Optional \code{dataframe} or \code{list} of test data containing the
variables included in the linear predictor of \code{formula}. If not supplied,
predictions are generated for the original observations used for the model fit.
Ignored if using one of the residual plots (i.e. 'resid_hist')}

\item{...}{Further arguments passed to \code{\link{predict.mvgam}}
as well as to the PPC function specified in \code{type}}
}
\value{
A ggplot object that can be further
customized using the \pkg{ggplot2} package.
}
\description{
Perform unconditional posterior predictive checks with the help
of the \pkg{bayesplot} package.
}
\details{
Unlike the conditional posterior checks provided by \code{\link{ppc}},
This function computes \emph{unconditional} posterior predictive checks (i.e. it generates
predictions for fake data without considering the true observations associated with those
fake data). For a detailed explanation of each of the ppc functions,
see the \code{\link[bayesplot:PPC-overview]{PPC}}
documentation of the \pkg{\link[bayesplot:bayesplot-package]{bayesplot}}
package.
}
\examples{
\dontrun{
simdat <- sim_mvgam(seasonality = "hierarchical")
mod <- mvgam(
  y ~ series +
    s(season, bs = "cc", k = 6) +
    s(season, series, bs = "fs", k = 4),
  data = simdat$data_train,
  chains = 2,
  silent = 2
)

# Use pp_check(mod, type = "xyz") for a list of available plot types

# Default is a density overlay for all observations
pp_check(mod)

# Rootograms particularly useful for count data
pp_check(mod, type = "rootogram")

# Grouping plots by series is useful
pp_check(mod,
  type = "bars_grouped",
  group = "series", ndraws = 50
)
pp_check(mod,
  type = "ecdf_overlay_grouped",
  group = "series", ndraws = 50
)
pp_check(mod,
  type = "stat_freqpoly_grouped",
  group = "series", ndraws = 50
)

# Several types can be used to plot distributions of randomized
# quantile residuals
pp_check(
  object = mod,
  x = "season",
  type = "resid_ribbon"
)
pp_check(
  object = mod,
  x = "season",
  group = "series",
  type = "resid_ribbon_grouped"
)
pp_check(mod,
  ndraws = 5,
  type = "resid_hist_grouped",
  group = "series"
)

# Custom functions accepted
pp_check(mod, type = "stat", stat = function(x) mean(x == 0))
pp_check(mod,
  type = "stat_grouped",
  stat = function(x) mean(x == 0),
  group = "series"
)

# Some functions accept covariates to set the x-axes
pp_check(mod,
  x = "season",
  type = "ribbon_grouped",
  prob = 0.5,
  prob_outer = 0.8,
  group = "series"
)

# Many plots can be made without the observed data
pp_check(mod, prefix = "ppd")
}

}
\seealso{
\code{\link{ppc}}, \code{\link{predict.mvgam}}
}
\author{
Nicholas J Clark
}
