% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation_types.R
\name{mutation_types_convert_so_to_maf}
\alias{mutation_types_convert_so_to_maf}
\title{Convert SO Mutation Types to MAF}
\usage{
mutation_types_convert_so_to_maf(
  so_mutation_types,
  variant_type = NULL,
  inframe = NULL,
  split_on_ampersand = TRUE,
  missing_to_silent = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{so_mutation_types}{a vector of SO terms you want to convert to MAF variant classifications (character)}

\item{variant_type}{a vector describing each mutations type. Valid elements include: "SNP", "DNP", "TNP", "ONP", "DEL", "INS". Used to map frameshift_variant to more specific MAF columns (character)}

\item{inframe}{is the mutation inframe? (logical). Used to map protein_altering_variant to valid MAF columns}

\item{split_on_ampersand}{should '&' separated SO terms be automatically converted to single SO terms based on highest severity? (flag)}

\item{missing_to_silent}{should missing (NA) or empty ('') mutation types be converted to 'Silent' mutations?}

\item{verbose}{verbose (flag)}
}
\value{
matched MAF variant classification terms (character)
}
\description{
Convert SO Mutation Types to MAF
}
\examples{
mutation_types_convert_so_to_maf(c('INTRAGENIC', 'INTRAGENIC', 'intergenic_region'))
}
