% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_infrared_ineqmat.R
\name{make_infrared_ineqmat}
\alias{make_infrared_ineqmat}
\title{Define hyperplanes for infrared arrangements}
\usage{
make_infrared_ineqmat(card, include_wraparound = FALSE)
}
\arguments{
\item{card}{The cardinality of the scale(s) to be studied}

\item{include_wraparound}{Boolean: should hyperplanes that involve
intervals that wrap around the octave be included? Defaults to \code{FALSE}.}
}
\value{
A matrix with \code{card+1} columns and \code{k} rows (where \code{k} is the
number of hyperplanes in the arrangement). When \code{include_wraparound=TRUE},
\code{k} is the \code{card}th \href{https://oeis.org/A002817}{doubly triangular number}.
}
\description{
The "infrared" hyperplane arrangements are in some sense
an extension of the "pastel" arrangements to be more like the
Rothenberg arrangements. (This is the sense of the color-conceit
name for the arrangments: they contain red-like colors that we
don't see in ordinary use of modal color theory.) That is, the
infrared arrangment for a given color contains all the pastel hyperplanes
(except those filtered out when \code{include_wraparound=FALSE}),
plus additional ones that make comparisons between generic intervals
of different sizes (as the Rothenberg arrangements do). Unlike the
Rothenberg arrangements, however, the infrared arrangments are central:
every hyperplane passes through the "origin" generated by \code{\link[=edoo]{edoo()}}.
It should be the case that every infrared hyperplane either belongs
to the pastel arrangement or is parallel to one in a Rothenberg arrangement.
This family of arrangements is conceived primarily for the study
of voice leadings rather than scales themselves.
}
\details{
These arrangements are still somewhat experimental and may change.
In particular, the ordering of hyperplanes currently is inconsistent
between settings for \code{include_wraparound}.
}
\examples{
# To see the effect of "include_wraparound" param, compare to
# pastel arrangements:
make_pastel_ineqmat(3)
make_infrared_ineqmat(3)
make_infrared_ineqmat(3, include_wraparound=TRUE)

# In general, infrared arrangements are more complicated than pastel:
make_pastel_ineqmat(4)
make_infrared_ineqmat(4, include_wraparound=TRUE)

}
\seealso{
\code{\link[=make_pastel_ineqmat]{make_pastel_ineqmat()}} and \code{\link[=make_roth_ineqmat]{make_roth_ineqmat()}}
}
