% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute.R
\name{execute}
\alias{execute}
\alias{execute_multiverse}
\alias{execute_universe}
\title{Execute parts of, or the entire multiverse}
\usage{
execute_multiverse(multiverse, parallel = FALSE, progress = FALSE)

execute_universe(multiverse, .universe = 1, parallel = FALSE, progress = FALSE)
}
\arguments{
\item{multiverse}{The multiverse object}

\item{parallel}{Indicates whether to execute the multiverse analysis in parallel. If TRUE, multiverse makes use of
\code{future::future} as backend to support parallel processing. Requires configuration of \code{future::plan}. Defaults to FALSE.}

\item{progress}{Indicates whether to include a progress bar for each step of the execution. Defaults to FALSE.}

\item{.universe}{Indicate which universe to execute, if the user wants to execute a specific combination
of the parameters using \code{execute_universe()}. Defaults to NULL, which will execute the first (default) analysis.}
}
\description{
These are functions which allow the user to execute parts or whole of the multiverse.
The user can choose to either execute the default analysis using the \code{execute_universe()}, or the
whole of the multiverse using the \code{execute_multiverse()}.
}
\details{
Each single analysis within the multiverse lives in a separate environment. 
We provide convenient functions to access the results for the  default analysis, as well as 
parts or whole of the multiverse. Each analysis can also be accessed from the multiverse table,
under the results column.
}
\examples{
\donttest{
library(dplyr)

M <- multiverse()

inside(M, {
  data <- rnorm(100, 50, 20)

  x.mean <- mean(data, trim = branch(
    trim_values,
    "trim_none" ~ 0,
    "trim_1pc" ~ 0.05,
    "trim_5pc" ~ 0.025,
    "trim_10pc" ~ 0.05
  ))
})

# Computes the analysis for all
# universes in the multiverse`
M \%>\%
  execute_multiverse()
}

}
