% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_mediators}
\alias{plot_mediators}
\title{Visualize Indirect Effects}
\usage{
plot_mediators(
  indirect_effects,
  exper,
  n_digit = 3,
  n_panels = NULL,
  treatment = "treatment",
  ...
)
}
\arguments{
\item{indirect_effects}{A data.frame containing estimated indirect effects
for each variable, under different counterfactual settings for the "direct
treatment." This is the output of \code{indirect_pathwise}.}

\item{exper}{An object of class \code{mediation_data} containing all mediation
analysis data.}

\item{n_digit}{The number of digits of the indirect effects to print next to
each panel. Defaults to 3.}

\item{n_panels}{The number of mediator-outcome pairs to show. Defaults to 12,
or the number of pathways, if there are fewer than 12.}

\item{treatment}{What is the name of the treatment variable that we want to
overlay on points? This is necessary when there are several potential
treatment variables. Defaults to "treatment."}

\item{...}{Further keyword arguments passed to \code{patchwork::wrap_plots}.}
}
\value{
A patchwork-based arrangement of ggplot2 grobs.
}
\description{
This is a helper function to visualize the raw data responsible for the
largest indirect effects. It returns a faceted plot of outcome vs. mediator
pairs for those with high pathwise indirect effects.
}
\examples{
# dataset with no true effects
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
ie <- multimedia(exper) |>
    estimate(exper) |>
    indirect_pathwise() |>
    effect_summary()
plot_mediators(ie, exper)

# another dataset
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
ie <- multimedia(exper, rf_model()) |>
    estimate(exper) |>
    indirect_pathwise() |>
    effect_summary()
plot_mediators(ie, exper)

}
