% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimators.R
\name{glmnet_sampler}
\alias{glmnet_sampler}
\title{Sample from a 'Glmnet' Package Model}
\usage{
glmnet_sampler(fits, newdata = NULL, indices = NULL, lambda_ix = 1, ...)
}
\arguments{
\item{fits}{The fitted 'glmnet' package model model from which to draw
samples.}

\item{newdata}{A data.frame containing new inputs from which to sample
responses. If NULL, defaults to the data used to estimate fit.}

\item{indices}{The coordinates of the response from which to draw samples.}

\item{lambda_ix}{A regularization strength parameter used to maintain
consistency with estimation. Not used during sampling.}

\item{...}{Additional parameters to pass to predict.glmnet}
}
\value{
y_star A data.frame of samples y associated with the new inputs.
}
\description{
This assumes a continuous response, so that the out-of-sample MSE can be used
to estimate the outcome variability sigma.
}
\examples{
m <- glmnet_model()
fit <- estimator(m)(mpg ~ hp + wt, data = mtcars)
glmnet_sampler(fit, mtcars)

plm <- parallelize(glmnetUtils::glmnet)
fit <- plm(mpg + disp ~ hp + wt, data = mtcars)
glmnet_sampler(fit, mtcars)
}
