% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{evaluateLags}
\alias{evaluateLags}
\title{Create lag variables and evaluate models with different number of lags}
\usage{
evaluateLags(formula, lagvar, nlags = 0L, idvar, data, ...)
}
\arguments{
\item{formula}{A \code{character} string giving the \code{\link[lme4]{lmer}} formula
to use as a base. The variable to be tested with lags gets added as fixed effects
only to this, currently.}

\item{lagvar}{A \code{character} string giving the name of the variable to test lags for.}

\item{nlags}{An \code{integer} (e.g., 0L, 3L) giving the number of lags to test. Defaults
to 0L but really should be more. Must be a positive integer.}

\item{idvar}{A \code{character} string giving the name o the ID variable.}

\item{data}{A \code{data.table} dataset ideally or at least a \code{data.frame}.}

\item{...}{Additional arguments passed to \code{lmer}, used to control model fitting.}
}
\description{
This function creates the desired number of lags and tests consecutive models
from a model with no lags (lag 0), lag 0 + lag1, etc. and reports model performance.
This helps evaluate how many lags are needed.
}
\details{
Currently only linear mixed effects models are allowed.
}
\examples{
## these examples are slow to run
data(aces_daily, package = "JWileymisc")

evaluateLags(
 "NegAff ~ Female + Age + BornAUS + (1 | UserID)",
 "STRESS",
 4L,
 "UserID",
 aces_daily)

\donttest{
 ## not run, more complex example with random slope, fails to converge
evaluateLags(
 "NegAff ~ Female + Age + BornAUS + (1 + STRESS | UserID)",
 "STRESS",
 5L,
 "UserID",
 aces_daily)

## use different control to fit model and now converges
strictControl <- lme4::lmerControl(optCtrl = list(
   algorithm = "NLOPT_LN_NELDERMEAD",
   xtol_abs = 1e-10,
   ftol_abs = 1e-10))
evaluateLags(
 "NegAff ~ Female + Age + BornAUS + (1 + STRESS | UserID)",
 "STRESS",
 5L,
 "UserID",
 aces_daily,
control = strictControl)
}
}
