% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{.summary.ID}
\alias{.summary.ID}
\title{Summarize a Variable in a Long Dataset by ID}
\usage{
.summary.ID(data, var, idvar, CI = 0.95, robust = FALSE)
}
\arguments{
\item{data}{A data.table object, long format}

\item{var}{A character string, the name of the variable to summarize}

\item{idvar}{A character string, the name of the grouping variable}

\item{CI}{A numeric value, the confidence interval to use. Default is .95.}

\item{robust}{A logical. Default is \code{FALSE}.
If \code{TRUE}, the function will use the median as the estimate.
If \code{FALSE}, the function will use the mean as the estimate.}
}
\value{
A data.table object with the mean/median, lower limit, and upper limit of the variable
  specified in \code{var} for each level of the grouping variable specified in \code{idvar}.
}
\description{
Summarize a Variable in a Long Dataset by ID
}
\keyword{internal}
