% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sopls_plots.R
\name{sopls_plots}
\alias{sopls_plots}
\alias{loadings.sopls}
\alias{scores.sopls}
\alias{loadingplot.sopls}
\alias{scoreplot.sopls}
\alias{biplot.sopls}
\alias{corrplot.sopls}
\title{Scores, loadings and plots for sopls objects}
\usage{
\method{loadings}{sopls}(object, ncomp = "all", block = 1, y = FALSE, ...)

\method{scores}{sopls}(object, ncomp = "all", block = 1, y = FALSE, ...)

\method{scoreplot}{sopls}(
  object,
  comps = 1:2,
  ncomp = NULL,
  block = 1,
  labels,
  identify = FALSE,
  type = "p",
  xlab,
  ylab,
  ...
)

\method{loadingplot}{sopls}(
  object,
  comps = 1:2,
  ncomp = NULL,
  block = 1,
  scatter = TRUE,
  labels,
  identify = FALSE,
  type,
  lty,
  lwd = NULL,
  pch,
  cex = NULL,
  col,
  legendpos,
  xlab,
  ylab,
  pretty.xlabels = TRUE,
  xlim,
  ...
)

\method{corrplot}{sopls}(
  object,
  comps = 1:2,
  ncomp = NULL,
  block = 1,
  labels = TRUE,
  col = 1:5,
  plotx = TRUE,
  ploty = TRUE,
  ...
)

\method{biplot}{sopls}(
  x,
  comps = 1:2,
  ncomp = "all",
  block = 1,
  which = c("x", "y", "scores", "loadings"),
  var.axes = FALSE,
  xlabs,
  ylabs,
  main,
  ...
)
}
\arguments{
\item{object}{\code{sopls} object}

\item{ncomp}{\code{integer} vector giving components from all blocks before \code{block} (see next argument).}

\item{block}{\code{integer} indicating which block to extract components from.}

\item{y}{\code{logical} extract Y loadings/scores instead of X loadings/scores (default = FALSE).}

\item{...}{further arguments sent to the underlying plot function(s)}

\item{comps}{\code{integer} vector giving components, within block, to plot (see Details regarding combination of blocks).}

\item{labels}{\code{character} indicating if "names" or "numbers" should be plot symbols (optional).}

\item{identify}{\code{logical} for activating \code{identify} to interactively identify points.}

\item{type}{\code{character} for selecting type of plot to make. Defaults to "p" (points) for scatter plots and "l" (lines) for line plots.}

\item{xlab}{\code{character} text for x labels.}

\item{ylab}{\code{character} text for y labels.}

\item{scatter}{\code{logical} indicating if a scatterplot of loadings should be made (default = TRUE).}

\item{lty}{Vector of line type specifications (see \code{\link{par}} for details).}

\item{lwd}{\code{numeric} vector of line width specifications.}

\item{pch}{Vector of point specifications (see \code{\link{points}} for details).}

\item{cex}{\code{numeric} vector of plot size expansions (see \code{\link{par}} for details).}

\item{col}{\code{integer} vector of symbol/line colours (see \code{\link{par}} for details).}

\item{legendpos}{\code{character} indicating legend position (if \code{scatter} is FALSE), e.g. \code{legendpos = "topright"}.}

\item{pretty.xlabels}{\code{logical} indicating if xlabels should be more nicely plotted (default = TRUE).}

\item{xlim}{\code{numeric} vector of length two, with the x limits of the plot (optional).}

\item{plotx}{\code{locical} or \code{integer}/\code{character}.  Whether to plot the \eqn{X} correlation loadings, optionally which block(s). Defaults to \code{TRUE}.}

\item{ploty}{\code{logical}.  Whether to plot the \eqn{Y} correlation loadings. Defaults to \code{TRUE}.}

\item{x}{\code{sopls} object}

\item{which}{\code{character} for selecting type of biplot ("x" = default, "y", "scores", "loadings").}

\item{var.axes}{\code{logical} indicating if second axes of a biplot should have arrows.}

\item{xlabs}{\code{character} vector for labelling first set of biplot points (optional).}

\item{ylabs}{\code{character} vector for labelling second set of biplot points (optional).}

\item{main}{\code{character} for setting the main title of a plot.}
}
\description{
Extraction of \code{scores} and \code{loadings} and adaptation of \code{scoreplot},
\code{loadingplot} and \code{biplot} from package \code{pls} for \code{sopls} objects.
}
\details{
If \code{comps} is supplied as a \code{list} for \code{scoreplot}, it is assumed that its elements refer to each of the
blocks up to block number \code{block}. For instance \code{comps = list(1, 0, 1:2)} will select 1 component from the first
block, no components from the second block and the first two components from the last block. This must be
matched by \code{ncomp}, specifying how many components were selected before block number \code{block}.
}
\examples{
data(potato)
so <- sopls(Sensory ~ Chemical + Compression + NIRraw, data=potato, ncomp=c(5,5,5))

# Loadings
loadings(so, ncomp=c(3), block=2)[, 1:3]

# Scores
scores(so, block=1)[, 1:4]

# Default plot from first block
scoreplot(so)

# Second block with names
scoreplot(so, ncomp=c(3), block=2, labels="names")

# Scatterplot matrix
scoreplot(so, ncomp=c(3,2), block=3, comps=1:3)

# Combination of blocks (see Details)
scoreplot(so, ncomp=c(3,2), block=3, comps=list(1,0,1))

# Default plot from first block
loadingplot(so, scatter=TRUE)

# Second block with names
loadingplot(so, ncomp=c(3), block=2, labels="names", scatter=TRUE)

# Scatterplot matrix
loadingplot(so, ncomp=c(3,2), block=3, comps=1:3, scatter=TRUE)

# Correlation loadings
corrplot(so, block=2, ncomp=1)

# Default plot from first block
biplot(so)
}
\seealso{
Overviews of available methods, \code{\link{multiblock}}, and methods organised by main structure: \code{\link{basic}}, \code{\link{unsupervised}}, \code{\link{asca}}, \code{\link{supervised}} and \code{\link{complex}}.
Common functions for computation and extraction of results are found in \code{\link{sopls_results}}.

#' @return The score and loading functions return scores and loadings, while plot functions have no return (except use of 'identify').
}
